%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% survival strategy (transition only if inviable or at min fuel)

function [endStates rulesExecuted transCost] = STRATcollapsed_survive(MAU,rulePaths,costPaths)

numDesigns = size(MAU,1);
numEpochs = size(MAU,2);

endStates = zeros(numDesigns,numEpochs);
rulesExecuted = cell(numDesigns,numEpochs);
transCost = cell(numDesigns,numEpochs);

% set NaN MAUs to -1 (failure)
MAU(isnan(MAU)) = -1;

for d = 1:numDesigns
    disp(['Calculating Survival strategy results for design: ' num2str(d)])
    for e = 1:numEpochs
        
        % determine if transition is necessary
        remainder = mod(d,8);  % 1 == min fuel
        if remainder == 0
            remainder = 8;
        end
        currMAU = MAU(d,e);    % -1 == inviable
        
        if currMAU == -1
            % check if maxing fuel will make viable, do that if so
            if MAU(d-remainder+8,e) ~= -1 && remainder ~= 8
                endStates(d,e) = d-remainder+8;
                pathOptions = costPaths{d,d-remainder+8};
                [~, idx] = sort(pathOptions(:,1));
                pathOptions = pathOptions(idx,:);
                transCost{d,e} = pathOptions(1,:);
                rulesExecuted{d,e} = rulePaths{d,d-remainder+8}{idx(1),:};
                
            else
                
                % else find the maxU available viable design
                
                % find available designs (nonempty cols of costPaths)
                available = [];
                for d2 = 1:numDesigns
                    if ~isempty(costPaths{d,d2})
                        available = [available d2];
                    end
                end
                
                % find avaiable design with highest MAU
                availableMAU = MAU(available,e);
                [sortedMAU indices] = sort(availableMAU); % sorts largest = last
                sortedAvailable = available(indices);
                
                
                if isempty(sortedAvailable)
                    endStates(d,e) = NaN;
                    break
                end
                currTarget = sortedAvailable(end);
                currTargetMAU = sortedMAU(end);
                
                if currTargetMAU == -1
                    endStates(d,e) = NaN;
                else
                    
                    pathOptions = costPaths{d,currTarget};
                    [~, idx] = sort(pathOptions(:,1));
                    pathOptions = pathOptions(idx,:);
                    
                    endStates(d,e) = currTarget;
                    rulesExecuted{d,e} = rulePaths{d,currTarget}{idx(1),:};
                    transCost{d,e} = pathOptions(1,:);
                    
                end
                
            end
            
        elseif remainder == 1  % viable, but min fuel --> max fuel as cheap as possible
            endStates(d,e) = d+7;
            pathOptions = costPaths{d,d+7};
            [~, idx] = sort(pathOptions(:,1));
            pathOptions = pathOptions(idx,:);
            transCost{d,e} = pathOptions(1,:);
            rulesExecuted{d,e} = rulePaths{d,d+7}{idx(1),:};
            
        end
    end
end


end